﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;


namespace Integration_ASP_NET
{
    [ValidationProperty("false")]
    public partial class ResponseHandling : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {

                string hash = string.Empty;
                string[] keys = Request.Form.AllKeys;
                Array.Sort(keys);
                string hash_string = string.Empty;
                hash_string = ConfigurationManager.AppSettings["SALT"];
                foreach (string hash_var in keys)
                {
                    if (Request.Form[hash_var] != "" && hash_var != "hash")
                    {
                        hash_string = hash_string + '|';
                        hash_string = hash_string + Request.Form[hash_var];
                    }
                }
                hash = Generatehash512(hash_string).ToUpper();         //generating hash
                                                                       // Response.Write(Request.Form);
                string b = Request.Form["hash"];
                if (Request.Form["hash"] == hash)
                {
                    if (Request.Form["response_code"] == "0")
                    {
                        Response.Write("Transaction is Successful");
                    }
                    else
                    {
                        string response_message = Request.Form["response_message"];
                        Response.Write("Correct the below error <br />");
                        Response.Write(response_message);
                    }
                }

                else
                {
                    Response.Write("Hash value did not matched");
                }
            }

            catch (Exception ex)
            {
                Response.Write("<span style='color:red'>" + ex.Message + "</span>");

            }
        }
        /// <summary>
        /// Generate HASH for encrypt all parameter passing while transaction
        /// </summary>
        /// <param name="text"></param>
        /// <returns></returns>
        public string Generatehash512(string text)
        {

            byte[] message = Encoding.UTF8.GetBytes(text);

            UnicodeEncoding UE = new UnicodeEncoding();
            byte[] hashValue;
            SHA512Managed hashString = new SHA512Managed();
            string hex = "";
            hashValue = hashString.ComputeHash(message);
            foreach (byte x in hashValue)
            {
                hex += String.Format("{0:x2}", x);
            }
            return hex;

        }
    }

}