﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Integration_ASP_NET
{
    public partial class Default : System.Web.UI.Page
    {
        public string action = string.Empty;
        public string hash = string.Empty;


        /// <summary>
        /// Generate HASH for encrypt all parameter passing while transaction
        /// </summary>
        /// <param name="text"></param>
        /// <returns></returns>
        public string Generatehash512(string text)
        {

            byte[] message = Encoding.UTF8.GetBytes(text);

            UnicodeEncoding UE = new UnicodeEncoding();
            byte[] hashValue;
            SHA512Managed hashString = new SHA512Managed();
            string hex = "";
            hashValue = hashString.ComputeHash(message);
            foreach (byte x in hashValue)
            {
                hex += String.Format("{0:x2}", x);
            }
            return hex;

        }

        protected void Button_Click(object sender, EventArgs e)
        {
            string api_key = ConfigurationManager.AppSettings["API_KEY"];
            string country = "IND";
            string currency = "INR";
            string return_url = ConfigurationManager.AppSettings["RETURN_URL"];

            try
            {
                string[] hashVarsSeq;
                string hash_string = string.Empty;

                frmError.Visible = false;
                hashVarsSeq = ConfigurationManager.AppSettings["hashSequence"].Split('|'); // spliting hash sequence from config
                hash_string = "";
                foreach (string hash_var in hashVarsSeq)
                {
                    if (hash_var == "api_key")
                    {
                        hash_string = hash_string + api_key;
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "amount")
                    {
                        hash_string = hash_string + Convert.ToDecimal(Request.Form[hash_var]).ToString("g29");
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "SALT")
                    {
                        hash_string = hash_string + ConfigurationManager.AppSettings["SALT"];
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "mode")
                    {
                        hash_string = hash_string + ConfigurationManager.AppSettings["MODE"];
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "country")
                    {
                        hash_string = hash_string + country;
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "currency")
                    {
                        hash_string = hash_string + currency;
                        hash_string = hash_string + '|';
                    }
                    else if (hash_var == "return_url")
                    {
                        hash_string = hash_string + return_url;
                        hash_string = hash_string + '|';
                    }
                    else
                    {
                        if (Request.Form[hash_var] != "")
                        {
                            hash_string = hash_string + Request.Form[hash_var];
                            hash_string = hash_string + '|';
                        }
                    }
                }

                hash_string = hash_string.Substring(0, hash_string.Length - 1);
                hash = Generatehash512(hash_string).ToUpper();         //generating hash
                action = ConfigurationManager.AppSettings["FSS_PAY_URL"];// setting URL

                if (!string.IsNullOrEmpty(hash))
                {


                    System.Collections.Hashtable data = new System.Collections.Hashtable(); // adding values in gash table for data post
                    data.Add("address_line_1", address_line_1.Text.Trim());
                    data.Add("address_line_2", address_line_2.Text.Trim());
                    string AmountForm = Convert.ToDecimal(amount.Text.Trim()).ToString("g29");// eliminating trailing zeros
                    data.Add("amount", AmountForm);
                    data.Add("api_key", api_key);
                    data.Add("city", city.Text.Trim());
                    data.Add("country", country);
                    data.Add("currency", currency);
                    data.Add("description", description.Text.Trim());
                    data.Add("email", email.Text.Trim());
                    data.Add("mode", ConfigurationManager.AppSettings["MODE"]);
                    data.Add("name", name.Text.Trim());
                    data.Add("order_id", order_id.Text.Trim());
                    data.Add("phone", phone.Text.Trim());
                    data.Add("return_url", return_url);
                    data.Add("state", state.Text.Trim());
                    data.Add("udf1", udf1.Text.Trim());
                    data.Add("udf2", udf2.Text.Trim());
                    data.Add("udf3", udf3.Text.Trim());
                    data.Add("udf4", udf4.Text.Trim());
                    data.Add("udf5", udf5.Text.Trim());
                    data.Add("zip_code", zip_code.Text.Trim());
                    data.Add("hash", hash);

                    string strForm = PreparePOSTForm(action, data);
                    Page.Controls.Add(new LiteralControl(strForm));
                }
            }

            catch (Exception ex)
            {
                Response.Write("<span style='color:red'>" + ex.Message + "</span>");

            }
        }
        private string PreparePOSTForm(string url, System.Collections.Hashtable data)      // post form
        {
            //Set a name for the form
            string formID = "PostForm";
            //Build the form using the specified data to be posted.
            StringBuilder strForm = new StringBuilder();
            strForm.Append("<form id=\"" + formID + "\" name=\"" +
                           formID + "\" action=\"" + url +
                           "\" method=\"POST\">");

            foreach (System.Collections.DictionaryEntry key in data)
            {

                strForm.Append("<input type=\"hidden\" name=\"" + key.Key +
                               "\" value=\"" + key.Value + "\">");
            }


            strForm.Append("</form>");
            //Build the JavaScript which will do the Posting operation.
            StringBuilder strScript = new StringBuilder();
            strScript.Append("<script language='javascript'>");
            strScript.Append("var v" + formID + " = document." +
                             formID + ";");
            strScript.Append("v" + formID + ".submit();");
            strScript.Append("</script>");
            //Return the form and the script concatenated.
            //(The order is important, Form then JavaScript)
            return strForm.ToString() + strScript.ToString();
        }
    }
}