<?php

if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

class ControllerResponsesExtensionBasispay extends AController{

    public $data = array();

    public function main(){

        $this->data['button_confirm'] = $this->language->get('button_confirm');
        $this->data['button_back'] = $this->language->get('button_back');

        if($this->config->get('embed_mode')) {
            $this->data['target_parent'] = 'target="_parent"';
        }

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $this->data['api_key']=$this->config->get('basispay_api');
        $this->data['order_id']=$order_info['order_id'];
        $this->data['currency'] = $order_info['currency'];
        $this->data['name'] =$order_info['firstname'].' '.$order_info['lastname'];
        $this->data['email'] = $order_info['email'];
        $this->data['amount'] = $this->currency->format($order_info['total'], $order_info['currency'], $order_info['value'], FALSE);
        $this->data['phone'] = $order_info['telephone'];
        $this->data['address_line_1'] = $order_info['payment_address_1'];
        $this->data['address_line_2'] = $order_info['payment_address_2'];
        $this->data['city'] = $order_info['payment_city'];
        $this->data['country'] = $order_info['payment_iso_code_3'];
        $this->data['description'] = 'BasispayV1.4_AbantecartV2.x: Paying invoice ' . $order_info['order_id'] . ' of store ' . $order_info['store_name'] . ' using abantecart plugin';
        $this->data['state']=$order_info['payment_zone'];
        $this->data['zip_code'] = $order_info['payment_postcode'];
        $this->data['return_url'] = $this->html->getSecureURL('extension/basispay/callback');
        $this->data['udf1'] = $order_info['ip'];

        if($this->config->get('basispay_mode')){
            $this->data['mode'] = 'TEST';
        }
        else{
            $this->data['mode']='LIVE';
        }

        $hash_columns = [
            'address_line_1',
            'address_line_2',
            'amount',
            'api_key',
            'city',
            'country',
            'currency',
            'description',
            'email',
            'mode',
            'name',
            'order_id',
            'phone',
            'return_url',
            'state',
            'udf1',
            'udf2',
            'udf3',
            'udf4',
            'udf5',
            'zip_code',
        ];

        ksort($hash_columns);
        $hash_data = $this->config->get('basispay_salt');

        foreach ($hash_columns as $column) {
            if (isset($this->data[$column])) {
                if (strlen($this->data[$column]) > 0) {
                    $hash_data .= '|' . trim($this->data[$column]);
                }
            }
        }
        $hash = null;
        if (strlen($hash_data) > 0) {
            $hash = strtoupper(hash("sha512", $hash_data));
        }
        $this->data['hash'] = $hash;
        if ($this->request->get['rt'] != 'checkout/guest_step_3') {
            $this->data['back'] = $this->html->getSecureURL('checkout/payment');
        } else {
            $this->data['back'] = $this->html->getSecureURL('checkout/guest_step_2');
        }
        $back = $this->request->get[ 'rt' ] != 'checkout/guest_step_3'
            ? $this->html->getSecureURL('checkout/payment')
            : $this->html->getSecureURL('checkout/guest_step_2');
        
        $this->data[ 'back' ] = HtmlElementFactory::create(array( 'type' => 'button',
            'name' => 'back',
            'text' => $this->language->get('button_back'),
            'style' => 'button',
            'href' => $back ));
        $this->data[ 'button_confirm' ] = HtmlElementFactory::create(
            array( 'type' => 'submit',
                'name' => $this->language->get('button_confirm'),
                'style' => 'button',
            ));

        $this->view->batchAssign( $this->data );
        $this->processTemplate('responses/basispay.tpl');
    }

    function callback() {

        $order_id=$this->request->post['order_id'];

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if(!$order_info){
            error_log('asd',0);
            return null;
        }
        $response_code = $this->request->post['response_code'];
        $response_message = $this->request->post['response_message'];
        $transaction_id =$this->request->post['transaction_id'];
        $amount =$this->request->post['amount'];
        $order_id=$this->request->post['order_id'];

        $hash_columns=$this->request->post;
        unset($hash_columns['hash']);
        ksort($hash_columns);

        $hash_data = $this->config->get('basispay_salt');
        foreach ($hash_columns as $key=>$value) {
            if (strlen($value) > 0) {
                $hash_data .= '|' . $value;
            }
        }
        $hash = null;
        if (strlen($hash_data) > 0) {
            $hash = strtoupper(hash("sha512", $hash_data));
        }

        if ($hash == $this->request->post['hash']) {
            if ($response_code == 0) {
                $this->model_checkout_order->confirm($order_id, $this->config->get('basispay_order_status_id'),'Payment ₹'.$amount.' is successful for Order Id '.$order_id.' and Transaction Id '.$transaction_id);
                $this->redirect($this->html->getURL('checkout/success'));
            }
            else if($response_code != 0){
                $msg = new AMessage();
                $msg->saveError('Basispay payment unsuccessful for order id '.$order_id,'Payment unsuccessful for order id '.$order_id.' ! ');
                $this->redirect($this->html->getSecureURL('extension/failed'));
            }
            }
        else{
            $msg = new AMessage();
            $msg->saveError('Basispay Hash mismatch for the order id '.$order_id,'Payment unsuccessful for order id '.$order_id.' due to hash mismatch ');
            $this->redirect($this->html->getSecureURL('extension/error'));
        }
    }
}
