<?php

use Tygh\Registry;

if (!defined('BOOTSTRAP')) { die('Access denied'); }

if (defined('PAYMENT_NOTIFICATION')) {
	$payment_id = db_get_field("SELECT payment_id FROM ?:orders WHERE order_id = ?i", $_REQUEST['order_id']);

	$processor_data = fn_get_payment_method_data($payment_id);

	if($_REQUEST['response_code'] == 0) {
		$pp_response['order_status'] = 'P';
		$pp_response["reason_text"] = "Auth Code: " . $_REQUEST['response_message'];
	} else {
		$pp_response['order_status'] = 'F';
		$pp_response["reason_text"] = "Bank Response: " . $_REQUEST['response_message'];
	}

	fn_finish_payment($_REQUEST['order_id'], $pp_response, false);
	fn_order_placement_routines('route', $_REQUEST['order_id']);
} else {
	$currency = $order_info['secondary_currency'];
	
	switch ($currency) {
	    case $processor_data['processor_params']['currency'] :
	        $api_key = $processor_data['processor_params']['api_key'];
	        $salt = $processor_data['processor_params']['salt'];
		break;
	    default:
	        die("ERROR: Cart Currency not configured for WorldNet Payment plug-in. Transaction not processed. Please contact site administrator.");
	}
	$paymentpage_url = "https://pay.basispay.in/v2/paymentrequest";
	$_order_id = ($order_info['repaid']) ? ($order_id .'_'. $order_info['repaid']) : $order_id;
	$return_url = fn_url("payment_notification.finish?payment=basispay&order_id={$_order_id}", AREA, 'current');
	$amount = $order_info['total'];

	$post['api_key'] = $api_key;
	$post['order_id'] = $_order_id;
	$post['currency'] = $currency;
	$post['name'] = $order_info['firstname'].' ' . $order_info['lastname'];
	$post['email'] = $order_info['email'];
	$post['amount'] = $amount;
	$post['phone'] = $order_info['phone'];
	$post['address_line_1'] = $order_info['b_address'];
	$post['address_line_2'] = $order_info['b_address_2'];
	$post['city'] = $order_info['b_city'];
	$post['country'] = $order_info['b_country'];
	if($post['country'] == 'IN'){
		$post['country'] = 'IND';
	};
	$post['description'] = 'Product info :'.$order_info['product'];
	$post['state'] = $order_info['b_state'];
	$post['zip_code'] = $order_info['b_zipcode'];
	$post['return_url'] = $return_url;

	$post['mode'] = $processor_data['processor_params']['test'];
	if($post['mode'] == 0){
		$post['mode'] = 'LIVE';
	}else{
		$post['mode'] = 'TEST';
	}
	$hash_columns = [
		'address_line_1',
		'address_line_2',
		'amount',
		'api_key',
		'city',
		'country',
		'currency',
		'description',
		'email',
		'mode',
		'name',
		'order_id',
		'phone',
		'return_url',
		'state',
		'udf1',
		'udf2',
		'udf3',
		'udf4',
		'udf5',
		'zip_code',
	];

	ksort($hash_columns);
	$hash_data = $salt;
	foreach ($hash_columns as $column) {
		if (isset($post[$column])) {
			if (strlen($post[$column]) > 0) {
				$hash_data .= '|' . trim($post[$column]);
			}
		}
	}
	$hash = null;
	if (strlen($hash_data) > 0) {
		$hash = strtoupper(hash("sha512", $hash_data));
	}
	$post["hash"] = $hash;
	
	fn_create_payment_form($paymentpage_url, $post, 'Basispay Hosted Payment Page');
}
exit;
