<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * basispay.com enrolment plugin - enrolment form.
 *
 * @package    enrol_basispay
 * @copyright  2017 Exam Tutor, Venkatesan R Iyengar
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$merchantkey = $this->get_config('merchantkey');
$merchantSALT = $this->get_config('merchantsalt');
$txnid = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
$amount = $cost;
$description = $coursefullname;
$label = "Pay Now";
$hash = '';


if ($this->get_config('checkproductionmode') == 1) {
	$mode = "LIVE";
} else {
	$mode = "TEST";
}
$url = "https://pay.basispay.in/v2/paymentrequest";

//$invoice = date('Ymd') . "-" . $instance->courseid . "-" . hash('crc32', $txnid); //udf3
$_SESSION['timestamp'] = $timestamp = time();
$udf1 = $instance->courseid.'-'.$USER->id.'-'.$instance->id.'-'.$context->id;
$enrolperiod = $instance->enrolperiod;//udf2
//Hash Sequence
$data = [];
$data['api_key'] = $merchantkey;
$data['order_id'] = $txnid;
$data['currency'] = $instance->currency;
$data['name'] = $USER->firstname;
$data['email'] = $USER->email;
$data['amount'] = $amount;
$data['phone'] = $_SESSION['timestamp'];
$data['address_line_1'] = $USER->address;
$data['city'] = $USER->city;
$data['country'] = $USER->country;
$data['description'] = $description;
$data['state'] = '';
$data['zip_code'] = '123456';
$data['return_url'] = $CFG->wwwroot.'/enrol/basispay/ipn.php';
$data['mode'] = $mode;
$data['udf1'] = $udf1;
$data['udf2'] = $enrolperiod;

$hash_columns = [
	'address_line_1',
	'address_line_2',
	'amount',
	'api_key',
	'city',
	'country',
	'currency',
	'description',
	'email',
	'mode',
	'name',
	'order_id',
	'phone',
	'return_url',
	'state',
	'udf1',
	'udf2',
	'udf3',
	'udf4',
	'udf5',
	'zip_code',
];
//var_dump($data);
ksort($hash_columns);
$hash_data = $merchantSALT;
foreach ($hash_columns as $column) {
	if (isset($data[$column])) {
		if (strlen($data[$column]) > 0) {
			$hash_data .= '|' . $data[$column];
		}
	}
}
//die($hash_data);
$hash = null;
if (strlen($hash_data) > 0) {
	$hash = strtoupper(hash("sha512", $hash_data));
}

$data['hash'] = $hash;

?>
<div align="center">
    <p>This course requires a payment for entry.</p>
    <p><b><?php echo $instancename; ?></b></p>
    <p><b><?php echo get_string("cost").": {$instance->currency} {$localisedcost}"; ?></b></p>
    <p><img alt="Basispay" src="<?php echo $CFG->wwwroot; ?>/enrol/basispay/pix/basispay.png" /></p>
    <p>
    <form method="post" action="<?php echo $url; ?>" >
        <input type="hidden" name="api_key" value="<?php echo $data['api_key']; ?>" />
        <input type="hidden" name="address_line_1" value="<?php echo $data['address_line_1'] ?>" />
        <input type="hidden" name="amount" value="<?php echo $data['amount']; ?>" />
        <input type="hidden" name="name" value="<?php echo $data['name']; ?>" />
        <input type="hidden" name="email" value="<?php echo $data['email']; ?>" />
        <input type="hidden" name="phone" value="<?php echo $data['phone']; ?>" />
        <input type="hidden" name="description" value="<?php echo $data['description']; ?>" />
        <input type="hidden" name="mode" value="<?php echo $data['mode']; ?>" />
        <input type="hidden" name="return_url" value="<?php echo $data['return_url'] ?>" />
        <input type="hidden" name="hash" value="<?php echo $data['hash']; ?>" />
        <input type="hidden" name="order_id" value="<?php echo $data['order_id']; ?>" />
        <input type="hidden" name="country" value="<?php echo $data['country'] ?>" />
        <input type="hidden" name="currency" value="<?php echo $data['currency'] ?>" />
        <input type="hidden" name="city" value="<?php echo $data['city'] ?>" />
        <input type="hidden" name="state" value="<?php echo $data['state'] ?>" />
        <input type="hidden" name="zip_code" value="<?php echo $data['zip_code']?>" />
        <input type="hidden" name="udf1" value="<?php echo $data['udf1'] ?>" />
        <input type="hidden" name="udf2" value="<?php echo $data['udf2']; ?>" />
        <input type="submit" id="basispay_button" value="Pay Using Basispay" />

    </form>
    </p>
</div>
<style type="text/css">
    #basispay_button{
        background:  #fffeeb no-repeat scroll 0 0 transparent;
        color: green;
        cursor: pointer;
        font-weight: bold;
        height: 10px;
        padding-bottom: 2px;
        width: 200px;
        height: 35px;
    }
</style>
