﻿using System;
using System.Collections.Generic;
using System.Web.Mvc;
using Nop.Core;
using Nop.Core.Domain.Payments;
using Nop.Plugin.Payments.BasisPay.Models;
using Nop.Services.Configuration;
using Nop.Services.Orders;
using Nop.Services.Payments;
using Nop.Services.Localization;
using Nop.Services.Logging;
using Nop.Services;
using Nop.Web.Framework.Controllers;

namespace Nop.Plugin.Payments.BasisPay.Controllers
{
    public class PaymentBasisPayController : BasePaymentController
    {
        private readonly ISettingService _settingService;
        private readonly IPaymentService _paymentService;
        private readonly IOrderService _orderService;
        private readonly IOrderProcessingService _orderProcessingService;
        private readonly BasisPayPaymentSettings _BasisPayPaymentSettings;
        private readonly PaymentSettings _paymentSettings;
        private readonly ILogger _logger;
        private readonly ILocalizationService _localizationService;
        public PaymentBasisPayController(ISettingService settingService,
        IPaymentService paymentService, IOrderService orderService,
             IOrderProcessingService orderProcessingService,
             ILocalizationService localizationService,
            BasisPayPaymentSettings BasisPayPaymentSettings,
            PaymentSettings paymentSettings, ILogger logger)
        {
            this._settingService = settingService;
            this._paymentService = paymentService;
            this._orderService = orderService;
            this._orderProcessingService = orderProcessingService;
            this._BasisPayPaymentSettings = BasisPayPaymentSettings;
            this._localizationService = localizationService;
            this._paymentSettings = paymentSettings;
            this._logger = logger;

        }


        [AdminAuthorize]
        [ChildActionOnly]
        public ActionResult Configure()
        {
            var model = new ConfigurationModel();
            model.Api_Key = _BasisPayPaymentSettings.Api_Key;
            model.Salt = _BasisPayPaymentSettings.Salt;
            model.TransactModeId = Convert.ToInt32(_BasisPayPaymentSettings.TransactMode);
            model.TransactModeValues = _BasisPayPaymentSettings.TransactMode.ToSelectList();
            //model.TransactModeValues = { "TEST","LIVE"};

            return View("~/Plugins/Payments.BasisPay/Views/PaymentBasisPay/Configure.cshtml", model);
        }

        [HttpPost]
        [AdminAuthorize]
        [ChildActionOnly]
        public ActionResult Configure(ConfigurationModel model)
        {
            if (!ModelState.IsValid)
                return Configure();

            //save settings
            _BasisPayPaymentSettings.Api_Key = model.Api_Key;
            _BasisPayPaymentSettings.Salt = model.Salt;
            _BasisPayPaymentSettings.TransactMode = (TransactMode)model.TransactModeId;

            _settingService.SaveSetting(_BasisPayPaymentSettings);

            SuccessNotification(_localizationService.GetResource("Admin.Plugins.Saved"));

            return Configure();
        }

        [ChildActionOnly]
        public ActionResult PaymentInfo()
        {
            var model = new PaymentInfoModel();
            return View("~/Plugins/Payments.BasisPay/Views/PaymentBasisPay/PaymentInfo.cshtml", model);

        }

        [NonAction]
        public override IList<string> ValidatePaymentForm(FormCollection form)
        {
            var warnings = new List<string>();
            return warnings;
        }

        [NonAction]
        public override ProcessPaymentRequest GetPaymentInfo(FormCollection form)
        {
            var paymentInfo = new ProcessPaymentRequest();
            return paymentInfo;
        }

        [ValidateInput(false)]
        public ActionResult Return(FormCollection form)
        {
            var processor = _paymentService.LoadPaymentMethodBySystemName("Payments.BasisPay") as BasisPayPaymentProcessor;
            if (processor == null ||
                !processor.IsPaymentMethodActive(_paymentSettings) || !processor.PluginDescriptor.Installed)
                throw new NopException("BasisPay module cannot be loaded");


            var myUtility = new BasisPayHelper();

            string[] hash_columns = Request.Form.AllKeys;
            Array.Sort(hash_columns);
            IDictionary<string, string> data = new Dictionary<string, string>();

            foreach (string column in hash_columns)
            {
                data.Add(column, form[column]);    
            }
            data["hash"] = "";
            string response_code, server_hash, hash,hash_data, response_message;    

            //Assign following values to send it to verifychecksum function.
            if (String.IsNullOrWhiteSpace(_BasisPayPaymentSettings.Salt))
                throw new NopException("BasisPay Salt is not set");

            data.Add("salt", _BasisPayPaymentSettings.Salt.ToString());
            server_hash = form["hash"];
            response_code = form["response_code"];
            response_message = form["response_message"];

            string[] hash_values = myUtility.gethash(hash_columns, data);
            hash_values[0] = hash_values[0].Remove(0, 40);
            hash_values[0] = hash_values[0].Insert(0, "****************SALT********************");

            hash_data = hash_values[0];
            hash = hash_values[1];

            if (hash == server_hash)
            {

			 if(response_code == "0")
			 {
                var order = _orderService.GetOrderById(Convert.ToInt32(data["order_id"]));
                if (_orderProcessingService.CanMarkOrderAsPaid(order))
                {
                    _orderProcessingService.MarkOrderAsPaid(order);
                }
                    _logger.Information("Payment ₹" + data["amount"] + " successful for Order Id " + data["order_id"]+ " and Transaction Id "+form["transaction_id"]);
                    //Thank you for shopping with us. Your credit card has been charged and your transaction is successful
                    return RedirectToRoute("CheckoutCompleted", new { orderId = order.Id});
			  }
             else if (response_message != "0")
                {
                    _logger.Error("Payment unsuccessful for Order Id " + data["order_id"]);
                    return View("~/Plugins/Payments.BasisPay/Views/PaymentBasisPay/Failure.cshtml");
                }
			  
			  else
			  {
                    var errorModel = new ErrorModel();
                    errorModel.Error = response_message;
                    return View("~/Plugins/Payments.BasisPay/Views/PaymentBasisPay/Error.cshtml",errorModel);

                }

            }
            
            
            else
            {
                _logger.Error("Hash mis matched !,Hash Calculated with data sent by server is : "+ hash_data);
                return View("~/Plugins/Payments.BasisPay/Views/PaymentBasisPay/Hash_Failure.cshtml");
            }
        }
    }
}