<?php

// Please make sure you insert your merchant id in the OSC admin area

class basispay {

	var $code, $title, $description, $enabled, $_order_id;


// class constructor

	function basispay()
	{

		global $order;

		$this->code = 'basispay';

		$this->title = MODULE_PAYMENT_BASISPAY_TEXT_TITLE;


		$this->sort_order = MODULE_PAYMENT_BASISPAY_SORT_ORDER;

		$this->enabled = ((MODULE_PAYMENT_BASISPAY_STATUS == 'True') ? true : false);


		$this->form_action_url = 'https://pay.basispay.in/v2/paymentrequest';

	}

	function javascript_validation()
	{

	}

	function selection()
	{

		$selection = [
			'id' => $this->code,

			'module' => $this->title,
		];

		return $selection;

	}


	function pre_confirmation_check()
	{

		return false;
	}


	function confirmation()
	{

		global $HTTP_POST_VARS;

		$confirmation = '';

		return $confirmation;

	}

	function process_button()
	{

		global $HTTP_POST_VARS, $order;

		$posted = [];
		$amt = $order->info['total'];
		$hash_columns = [
			'address_line_1', 'address_line_2', 'amount', 'api_key', 'city', 'country', 'currency', 'description',
			'email', 'mode', 'name', 'order_id',
			'phone', 'return_url', 'state', 'udf1', 'udf2', 'udf3', 'udf4', 'udf5', 'zip_code',
		];

		$posted['address_line_1'] = $order->customer['street_address'];
		$posted['address_line_2'] = $order->customer['lastname'];
		$posted['amount'] = $amt;
		$posted['api_key'] = MODULE_PAYMENT_BASISPAY_APIKEY;
		$posted['city'] = $order->customer['city'];
		$posted['country'] = $order->customer['country']['iso_code_3'];
		$posted['currency'] = $order->info['currency'];
		$posted['description'] = 'description';
		$posted['email'] = $order->customer['email_address'];
		$posted['mode'] = MODULE_PAYMENT_BASISPAY_TESTMODE;
		$posted['name'] = $order->customer['firstname'];
		$posted['order_id'] = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
		$posted['phone'] = $order->customer['telephone'];
		$posted['return_url'] = tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL');
		$posted['state'] = $order->customer['state'];
		$posted['zip_code'] = $order->customer['postcode'];

		ksort($hash_columns);
		$hash_data = MODULE_PAYMENT_BASISPAY_SALT;
		foreach ($hash_columns as $column) {
			if (isset($posted[$column])) {
				if (strlen($posted[$column]) > 0) {
					$hash_data .= '|' . trim($posted[$column]);
				}
			}
		}
		$hash = null;
		if (strlen($hash_data) > 0) {
			$hash = strtoupper(hash("sha512", $hash_data));
		}
		$posted['hash'] = $hash;


		$process_button_string =
			tep_draw_hidden_field('address_line_1', $posted['address_line_1']) .
			tep_draw_hidden_field('address_line_2', $posted['address_line_2']) .
			tep_draw_hidden_field('amount', $posted['amount']) .
			tep_draw_hidden_field('api_key', $posted['api_key']) .
			tep_draw_hidden_field('city', $posted['city']) .
			tep_draw_hidden_field('country', $posted['country']) .
			tep_draw_hidden_field('currency', $posted['currency']) .
			tep_draw_hidden_field('description', $posted['description']) .
			tep_draw_hidden_field('email', $posted['email']) .
			tep_draw_hidden_field('mode', $posted['mode']) .
			tep_draw_hidden_field('name', $posted['name']) .
			tep_draw_hidden_field('order_id', $posted['order_id']) .
			tep_draw_hidden_field('phone', $posted['phone']) .
			tep_draw_hidden_field('return_url', $posted['return_url']) .
			tep_draw_hidden_field('state', $posted['state']) .
			tep_draw_hidden_field('zip_code', $posted['zip_code']) .
			tep_draw_hidden_field('hash', $posted['hash']);

		return $process_button_string;

	}

	function before_process()
	{
		global $order;

		$hash_columns = $_POST;
		unset($hash_columns['hash']);
		ksort($hash_columns);

		$private_salt = MODULE_PAYMENT_BASISPAY_SALT;
		$hash_data = $private_salt;

		foreach ($hash_columns as $key => $value) {
			if (strlen($value) > 0) {
				$hash_data .= '|' . $value;
			}
		}
		$hash = null;
		if (strlen($hash_data) > 0) {
			$hash = strtoupper(hash("sha512", $hash_data));
		}
		if ($hash == $_POST['hash']) {

			if ($_POST['response_code'] != 0) {
				tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT,
					'error_message=Transaction Failed,Please try again', 'SSL', true, false));
			}

		} else {
			tep_redirect(tep_href_link(FILENAME_CHECKOUT_PAYMENT, 'error_message=Data Dampered', 'SSL', true, false));

		}
	}

	function after_process()
	{

		global $HTTP_POST_VARS, $order, $insert_id;

		$result = 'Transaction ID: ' . tep_output_string_protected($HTTP_POST_VARS['transaction_id']) . "\n" .
			'Payment Method: ' . tep_output_string_protected($HTTP_POST_VARS['payment_method']) . "\n" .
			'Response Message: ' . tep_output_string_protected($HTTP_POST_VARS['response_message']);

		$sql_data_array = [
			'orders_id'         => (int)$insert_id,
			'orders_status_id'  => (int)$order->info['order_status'],
			'date_added'        => 'now()',
			'customer_notified' => '0',
			'comments'          => $result,
		];

		tep_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_data_array);


	}


	function get_error()
	{


		$error = [
			'title' => MODULE_PAYMENT_EBS_TEXT_ERROR,

			'error' => stripslashes(urldecode($_GET['error'])),
		];

		return $error;

	}


	function check()
	{

		if (!isset($this->_check)) {


			$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_BASISPAY_STATUS'");


			$this->_check = tep_db_num_rows($check_query);


		}


		return $this->_check;

	}


	function install()
	{


		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Enable Basispay Payment Module', 'MODULE_PAYMENT_BASISPAY_STATUS', 'True', 'Do you want to accept Basispay payments?', '6', '0', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('API KEY', 'MODULE_PAYMENT_BASISPAY_APIKEY', '', 'Your API KEY of Basispay', '5', '0', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('SALT', 'MODULE_PAYMENT_BASISPAY_SALT', '', 'Your SALT of Basispay', '6', '0', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Test Mode', 'MODULE_PAYMENT_BASISPAY_TESTMODE', 'TEST', 'Test mode used for Basispay', '6', '0', 'tep_cfg_select_option(array(\'TEST\', \'LIVE\'), ', now())");

		tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Sort order of display', 'MODULE_PAYMENT_BASISPAY_SORT_ORDER', '0', 'Sort order of display. Lowest is displayed first.', '6', '2', now())");

	}


	function remove()
	{

		tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '",
				$this->keys()) . "')");

	}


	function keys()
	{

		return [
			'MODULE_PAYMENT_BASISPAY_STATUS', 'MODULE_PAYMENT_BASISPAY_APIKEY', 'MODULE_PAYMENT_BASISPAY_SALT',
			'MODULE_PAYMENT_BASISPAY_TESTMODE',
		];

	}

}

?>