<?php
use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_'))
    exit;

class Basispay extends PaymentModule {

public function __construct()
  {
    $this->name = 'basispay';  // The value MUST be the name of the module's folder.
    $this->tab = 'payments_gateways';
    $this->version = '0.0.2';
    $this->author = 'Basispay';
    $this->need_instance = 0;
    $this->currencies = true;
    $this->currencies_mode = 'radio';
    $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
    $this->bootstrap = true;
    $this->controllers = array('validation');


      parent::__construct();

    $this->page = basename(__FILE__, '.php'); 
    $this->displayName = $this->l('Basispay');
    $this->description = $this->l('Accept Payments using Basispay');
 
    $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
 
    if (!Configuration::get('BASISPAY'))
      $this->warning = $this->l('No name provided');
  }

public function install()
{

if (!parent::install() || 
    !$this->registerHook('paymentOptions') ||
    !$this->registerHook('paymentReturn') ||
    !Configuration::updateValue('BASISPAY', 'Instant payments')||
    !$this->createBasispayOrderDbTable()
    )
    return false;
 
    return true;
}

public function uninstall()
{
  if (!parent::uninstall() ||
    !Configuration::deleteByName('BASISPAY') ||
    !Configuration::deleteByName('BASISPAY_API_KEY') ||
    !Configuration::deleteByName('BASISPAY_PRIVATE_SALT')||
    !Configuration::deleteByName('BASISPAY_MODE')
  )
    return false;
 
  return true;
}
    /**
     * @return bool
     */
    private function createBasispayOrderDbTable()
    {
        return Db::getInstance()->Execute('CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'basispay_orders` (
					`order_id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
					`id_cart` INT(10) UNSIGNED NOT NULL,
					`order_id_status` varchar(30) DEFAULT "Initiated" ,
					`create_at` datetime
				)');
    }


    private function addOrderIdForCartId($id_cart){

        if (Db::getInstance()->execute('
			INSERT INTO `' . _DB_PREFIX_ . 'basispay_orders` (`id_cart`, `create_at`)
			VALUES ( "' . (int)$id_cart. '", NOW())')
        )
            return (int)Db::getInstance()->Insert_ID();

        return false;
    }
    /**
     * @param $status
     * @return bool
     */
    public function updateOrderIdStatus($order_id,$cart_id)
    {
        return Db::getInstance()->execute('
			UPDATE `' . _DB_PREFIX_ . 'basispay_orders`
			SET order_id_status = "Completed"
			WHERE `order_id`="' .$order_id. '" AND `id_cart`="' .$cart_id. '"' );
    }

public function getContent()
{
    $output = null;
    $all_fine = 0;
 
    if (Tools::isSubmit('submit'.$this->name))
    {
        
        $checkout_label = strval(Tools::getValue('BASISPAY_CHECKOUT_BUTTON_LABEL'));
        $api_key = strval(Tools::getValue('BASISPAY_API_KEY'));
        $private_salt = strval(Tools::getValue('BASISPAY_PRIVATE_SALT'));
        $mode = strval(Tools::getValue('BASISPAY_MODE'));

        if (!$checkout_label
          || empty($checkout_label)){
            Configuration::updateValue('BASISPAY_CHECKOUT_BUTTON_LABEL', "Pay using Basispay");
            $output .= $this->displayError($this->l('Invalid Configuration value for  Checkout button label. Default value of "Pay using Basispay" is going to be used.'));
            
        }else{
            $all_fine += 1;
            Configuration::updateValue('BASISPAY_CHECKOUT_BUTTON_LABEL', $checkout_label);
        }
        if (!$api_key
          || empty($api_key)){
            $output .= $this->displayError($this->l('Invalid Configuration value for API key.'));
            
        }else{
            $all_fine += 1;
            Configuration::updateValue('BASISPAY_API_KEY', $api_key);
        }
        if (!$private_salt
          || empty($private_salt)){
            $output .= $this->displayError($this->l('Invalid Configuration value for Private salt.'));
        }
        else{
            $all_fine += 1;
            Configuration::updateValue('BASISPAY_PRIVATE_SALT', $private_salt);
        }
        if (!$mode
            || empty($mode)){
            $output .= $this->displayError($this->l('Invalid MODE.'));
        }
        else{
            $all_fine += 1;
            Configuration::updateValue('BASISPAY_MODE', $mode);
        }
        if($all_fine === 4)
        {
            $output .= $this->displayConfirmation($this->l('All settings changed successfully.'));
        }
        else if($all_fine > 0 && $all_fine !== 4){
            $output .= $this->displayConfirmation($this->l('Some settings changed successfully.'));
        }
    }
    return $output.$this->displayForm();
}


public function displayForm()
{
    // Get default language
    $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
     
    // Init Fields form array
    $fields_form[0]['form'] = array(
        'legend' => array(
            'title' => $this->l('Settings'),
        ),
        'input' => array(
            array(
                'type' => 'text',
                'label' => $this->l('Checkout button label'),
                'name' => 'BASISPAY_CHECKOUT_BUTTON_LABEL',
                'size' => 32,
                'required' => false
            ),
            array(
                'type' => 'text',
                'label' => $this->l('API Key'),
                'name' => 'BASISPAY_API_KEY',
                'size' => 32,
                'required' => true
            ),
            array(
                'type' => 'text',
                'label' => $this->l('Private salt'),
                'name' => 'BASISPAY_PRIVATE_SALT',
                'size' => 32,
                'required' => true
            ),
            array(
                'type' => 'select',
                'label' => $this->l('Mode'),
                'name' => 'BASISPAY_MODE',
                //'value'=>"0",
                'options'	=>
                    array(
                        'query' => array (
                            array(
                                'id'	=> 'TEST',
                                'name' 	=> 'TEST'
                            ),
                            array(
                                'id' 	=> 'LIVE',
                                'name' 	=> 'LIVE'
                            )
                        ),
                        'id'	=> 'id',
                        'name'	=> 'name'
                    ),
            )
        ),
        'submit' => array(
            'title' => $this->l('Save'),
            'class' => 'button'
        )
    );

    $helper = new HelperForm();
     
    // Module, token and currentIndex
    $helper->module = $this;
    $helper->name_controller = $this->name;
    $helper->token = Tools::getAdminTokenLite('AdminModules');
    $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
     
    // Language
    $helper->default_form_language = $default_lang;
    $helper->allow_employee_form_lang = $default_lang;
     
    // Title and toolbar
    $helper->title = $this->displayName;
    $helper->show_toolbar = true;        // false -> remove toolbar
    $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
    $helper->submit_action = 'submit'.$this->name;
    $helper->toolbar_btn = array(
        'save' =>
        array(
            'desc' => $this->l('Save'),
            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.
            '&token='.Tools::getAdminTokenLite('AdminModules'),
        ),
        'back' => array(
            'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
            'desc' => $this->l('Back to list')
        )
    );

    $helper->fields_value['BASISPAY_CHECKOUT_BUTTON_LABEL'] = Configuration::get('BASISPAY_CHECKOUT_BUTTON_LABEL');
    $helper->fields_value['BASISPAY_API_KEY'] = Configuration::get('BASISPAY_API_KEY');
    $helper->fields_value['BASISPAY_PRIVATE_SALT'] = Configuration::get('BASISPAY_PRIVATE_SALT');
    $helper->fields_value['BASISPAY_MODE'] = Configuration::get('BASISPAY_MODE');

    return $helper->generateForm($fields_form);
}


public function hookPaymentOptions($params) {
    $cart_id=$params['cart']->id;
    $order_id=$this->addOrderIdForCartId($cart_id);

    if (!$this->active)
            return;
    PrestaShopLogger::addLog('Hook Payment Option starts for Basispay', 1, null, null, $order_id);

        $address = new Address($params['cart']->id_address_invoice);

        $customer = new Customer($params['cart']->id_customer);
        $api_key = Configuration::get('BASISPAY_API_KEY');
        $private_salt = Configuration::get('BASISPAY_PRIVATE_SALT');
        $mode=Configuration::get('BASISPAY_MODE');
        $name = substr(trim($address->firstname . ' ' . $address->lastname), 0, 20);
        $email = $email_address = $customer->email;
        $phone = !empty($address->phone_mobile)?$address->phone_mobile:$address->phone;
        $phone=trim($phone);
        if(strlen($phone)>10){
        $phone=substr($phone,-10);
        }

    $amount = $params['cart']->getOrderTotal(true);
        $amount=$this->amount_format($amount);
        $address_line_1=$address->address1;
        $address_line_2=$address->address2;
        $city=$address->city;
        $country=$address->country;
        if($country=='India'){
            $country='IND';
        }
    $description='BASISPAYV2_PrestashopV1.7.x: Paying invoice of BASISPAY order Id '.$order_id.' and cart Id '.$cart_id.' of store '.Configuration::get('PS_SHOP_NAME');
       $state ='';
       $zip_code=$address->postcode;
       $currency=$this->getCurrency()->iso_code;
      // $ip='';
    $return_url = Context::getContext()->link->getModuleLink($this->name, 'validation', array(), true);

    $data = Array();
    $data['api_key'] = $api_key;
    $data['order_id'] = $order_id;
    $data['currency'] = $currency;
    $data['name'] = $name;
    $data['email'] = $email;
    $data['amount'] = $amount;
    $data['phone'] = $phone;
    $data['address_line_1'] = $address_line_1;
    $data['address_line_2'] = $address_line_2;
    $data['city'] = $city;
    $data['country'] = $country;
    $data['description'] = $description;
    $data['state'] = $state;
    $data['zip_code'] = $zip_code;
    $data['return_url'] = $return_url;
    $data['udf1'] = $cart_id;
    $data['mode'] = $mode;
    $hash_columns = [
        'address_line_1',
        'address_line_2',
        'amount',
        'api_key',
        'city',
        'country',
        'currency',
        'description',
        'email',
        'mode',
        'name',
        'order_id',
        'phone',
        'return_url',
        'state',
        'udf1',
        'udf2',
        'udf3',
        'udf4',
        'udf5',
        'zip_code',
    ];

    ksort($hash_columns);
    $hash_data = $private_salt;

    foreach ($hash_columns as $column) {
        if (isset($data[$column])) {
            if (strlen($data[$column]) > 0) {
                $hash_data .= '|' . trim($data[$column]);
            }
        }
    }
    PrestaShopLogger::addLog('Hash data sent to the server is : '.$hash_data, 1, null, null, $order_id);

    $hash = null;
    if (strlen($hash_data) > 0) {
        $hash = strtoupper(hash("sha512", $hash_data));
    }

    $data['hash'] = $hash;
    $checkout_label = Configuration::get('BASISPAY_CHECKOUT_BUTTON_LABEL');
    $checkout_label = $checkout_label ? $checkout_label : "Pay using Basispay";

        $payment_link = 'https://pay.basispay.in/v2/paymentrequest';
        $this->smarty->assign('payment_link', $payment_link);
        $this->smarty->assign('checkout_label', $checkout_label);
        $this->smarty->assign('data', $data);
        $this->smarty->assign('path', __PS_BASE_URI__);
    $paymentForm = $this->fetch ('module:basispay/views/templates/front/basispay.tpl');
    $newOption = new PaymentOption();
    $newOption->setCallToActionText($this->trans('Pay Using Basispay', array(), 'Modules.Basispay.Shop'))
        ->setAction($this->context->link->getModuleLink($this->name, 'validation', array(), true))
        ->setForm($paymentForm);
    return [$newOption];

    }

    public function hookPaymentReturn()
    {

    }

  public function validateOrder($id_cart, $id_order_state, $amount_paid, $payment_method = 'Unknown', $response_message = null, $extra_vars = array(), $currency_special = null, $dont_touch_amount = false, $secure_key = false, Shop $shop = null) {
        if (!$this->active)
            return;

        parent::validateOrder((int) $id_cart, (int) $id_order_state, (float) $amount_paid, $payment_method, $response_message, $extra_vars, $currency_special, $dont_touch_amount, $secure_key, $shop);
    }
    public function amount_format($number)
    {
        $amount = round((float)$number, (int)2);
        $amount = number_format($amount,(int)2, '.', '');
        return $amount;
    }
}

?>
