<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/**
 * @since 1.5.0
 */

class BasispayValidationModuleFrontController extends ModuleFrontController
{
	/**
	 * @see FrontController::postProcess()
	 */
	public function postProcess()
	{
		$cart = $this->context->cart;
		if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active)
			Tools::redirect('index.php?controller=order&step=1');

		// Check that this payment option is still available in case the customer changed his address just before the end of the checkout process
		$authorized = false;
		foreach (Module::getPaymentModules() as $module)
			if ($module['name'] == 'basispay')
			{
				$authorized = true;
				break;
			}
		if (!$authorized)
			die($this->module->getTranslator()->trans('This payment method is not available.', array(), 'Modules.Basispay.Shop'));

		$customer = new Customer($cart->id_customer);
		if (!Validate::isLoadedObject($customer))
			Tools::redirect('index.php?controller=order&step=1');

		$currency = $this->context->currency;
		$total = (float)$cart->getOrderTotal(true, Cart::BOTH);

		$is_logged_in = Context::getContext()->customer->isLogged();

		$salt = Configuration::get('BASISPAY_PRIVATE_SALT');
		$order_id = $_POST["udf1"];
		$response_code = $_POST["response_code"];
		$transaction_id = $_POST["transaction_id"];
		$amount = $_POST["amount"];
		$response_message =$_POST['response_message'];

		$hash_columns = $_POST;
		unset($hash_columns['hash']);

		ksort($hash_columns);

		$hash_data = $salt;

		foreach ($hash_columns as $key=>$value) {
			if (strlen($value) > 0) {
				$hash_data .= '|' . $value;
			}
		}
		$hash = null;

		if (strlen($hash_data) > 0) {
			$hash = strtoupper(hash('sha512', $hash_data));
		}

		$extra_vars = array('transaction_id' => $transaction_id);
		$basispay = new Basispay();
		$basispay->updateOrderIdStatus($_POST["order_id"],$_POST["udf1"]);

		if ($hash == $_POST['hash']) {
			if ($response_code == 0) {
				$extra_vars['reason'] = "Payment successful";
				PrestaShopLogger::addLog('Payment '.$amount .' is successful for BASISPAY Order Id '.$_POST["order_id"].' , Cart Id '.$order_id.' and Transaction Id '. $transaction_id, 1, null, null, $order_id);

				$this->module->validateOrder($cart->id, Configuration::get('PS_OS_WS_PAYMENT'), $total, $this->module->displayName, NULL, $extra_vars, (int)$currency->id, false, $customer->secure_key);

				if ($is_logged_in) {
					Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
				} else {
					Tools::redirectLink(_PS_BASE_URL_ . __PS_BASE_URI__ . 'index.php?controller=guest-tracking' . '&id_order=' . (int)$this->module->currentOrder . '&email=' . urlencode($customer->email));
				}
			}else{
				PrestaShopLogger::addLog('Payment unsuccessful for BASISPAY Order Id '.$_POST["order_id"].' and Cart Id '.$order_id , 1, null, null, $order_id);
				$extra_vars['reason'] = "Payment failed";
				$this->module->validateOrder($cart->id, _PS_OS_ERROR_, $total, $this->module->displayName, NULL, $extra_vars, (int)$currency->id, false, $customer->secure_key);
				Tools::redirect(_PS_BASE_URL_ . __PS_BASE_URI__ . 'index.php?controller=order-detail&id_order=' . (int)$this->module->currentOrder);
			}
		}else{
			$extra_vars['reason'] = "Hash mis matched";
			PrestaShopLogger::addLog('Hash mis matched', 1, null, null, $order_id);
			PrestaShopLogger::addLog('Hash Calculated with data sent by server is :'.$hash_data , 1, null, null, $order_id);
			PrestaShopLogger::addLog('Hash Calculated :'.$hash, 1, null, null, $order_id);
			PrestaShopLogger::addLog('Hash from the server is : '.$_POST['hash'], 1, null, null, $order_id);

			$this->module->validateOrder((int)$cart->id, _PS_OS_ERROR_, $amount, $basispay->displayName, NULL, $extra_vars, NULL, false, $customer->secure_key, NULL);
			Tools::redirect(_PS_BASE_URL_ . __PS_BASE_URI__ . 'index.php?controller=order-detail&id_order=' . (int)$this->module->currentOrder);
		}














		//	$this->module->validateOrder($cart->id, Configuration::get('PS_OS_BANKWIRE'), $total, $this->module->displayName, NULL, $mailVars, (int)$currency->id, false, $customer->secure_key);
		//$this->module->validateOrder((int)$cart->id, _PS_OS_PAYMENT_, $amount, $basispay->displayName, null, $extra_vars, null, false, $customer->secure_key);

		//Tools::redirect('index.php?controller=order-confirmation&id_cart='.$cart->id.'&id_module='.$this->module->id.'&id_order='.$this->module->currentOrder.'&key='.$customer->secure_key);
	}
}
