<?php
/**
 * @file
 * basispay menu items.
 *
 */

function uc_basispay_complete() {
  $salt_key = variable_get('uc_basispay_secret_salt', '');
  $order_id = $_POST["order_id"];
  $response_code = $_POST["response_code"];
  $response_message = $_POST["response_message"];
  $transaction_id = $_POST["transaction_id"];
  $amount = $_POST["amount"];

  $hash_columns = $_POST;
  unset($hash_columns['hash']);

  ksort($hash_columns);

  $hash_data = $salt_key;

  foreach ($hash_columns as $key=>$value) {
    if (strlen($value) > 0) {
      $hash_data .= '|' . $value;
    }
  }

  $hash = null;
  if (strlen($hash_data) > 0) {
    $hash = strtoupper(hash("sha512", $hash_data));
  }


  $order = uc_order_load($order_id);

  if ($hash == $_POST['hash']) {
    if ($response_code == 0) {

      $comment = t('Basispay transaction ID: @txn_id', array('@txn_id' => $transaction_id));
      uc_payment_enter($order_id, 'basispay', $amount, $order->uid, NULL, $comment);
      uc_cart_complete_sale($order);
      uc_order_comment_save($order_id, 0, t('Basispay reported a payment of @amount @currency.', array('@amount' => uc_currency_format($amount, FALSE), '@currency' => $_POST['currency'])));
      $_SESSION['uc_checkout'][$_SESSION['cart_order']]['do_complete'] = TRUE;
      watchdog('uc_basispay', 'Payment ₹ !amount is successful for Order Id !order_id and Transaction Id !transaction_id.', array(
          '!order_id' => $order_id,'!amount' =>  $amount,'!transaction_id' => $transaction_id,
      ), WATCHDOG_INFO);
      drupal_goto('cart/checkout/complete');
    }
    else if($response_message == 'Transaction Failed'){
      $url=$GLOBALS['base_url'];
      uc_order_comment_save($order_id, 0, t("The customer's attempted payment from a bank account failed."), 'admin');
      unset($_SESSION['cart_order']);
      $message='<p>There was a problem processing your payment and the order did not complete.</p>
                <p>Possible reasons are:</p>
                  <ul>
                      <li>Insufficient funds</li>
                      <li>Verification failed</li>
                  </ul>
                  <p>Please try to order again using a different payment method.</p>'.
          '<a href='.$url.'>Return to the home page.</a>';
      drupal_set_message($message,'error');
      watchdog('uc_basispay', 'Payment unsuccessful for Order Id @order_id', array('@order_id' => $order_id), WATCHDOG_ERROR);
      drupal_goto('cart');
    }
    else{
      $url=$GLOBALS['base_url'];
      $response_message=substr($response_message,strpos($response_message, ' - ')+2);
      $message='<p>Correct the below error.</p>.<h2>'.$response_message.'</h2>'.'<a href='.$url.'>Return to the home page.</a>';
      drupal_set_message($message,'error');
      drupal_goto('cart');

    }
  }
  else{
    $url=$GLOBALS['base_url'];
    unset($_SESSION['cart_order']);
    $message='<p>There was a problem processing your payment .</p>
      <p>Account may debited check the account balance before proceeding with another payment.</p>'
        . '<a href='.$url.'>Return to the home page.</a>';

    drupal_set_message($message, 'error');
    watchdog('uc_basispay', 'Hash mismatch , Hash Calculated with data sent by server is : @hash_data', array('@hash_data' => $hash_data), WATCHDOG_ERROR);
    drupal_goto('cart');
  }
}
